//
//  TodoItemRow.swift
//  Do It
//
//  Created by Jim Dovey on 5/20/20.
//  Copyright © 2020 Pragmatic Programmers. All rights reserved.
//

import SwiftUI

struct TodoItemRow: View {
    let item: TodoItem
    @State var showAlert = false
    
    var body: some View {
        HStack {
            Button(action: {
                self.showAlert.toggle()
            }) {
                Image(systemName: item.complete
                        ? "largecircle.fill.circle"
                        : "circle")
                    .imageScale(.large)
                    .foregroundColor(.accentColor)
            }
            .padding(.trailing, 6)
            .buttonStyle(HighPriorityButtonStyle())
            .alert(isPresented: $showAlert) {
                Alert(title: Text("Complete!"),
                      message: Text("This will work soon, honest."),
                      dismissButton: .default(Text("OK")))
            }
            
            VStack(alignment: .leading) {
                Text(item.title)
                    .font(.headline)
                
                if item.notes != nil {
                    Text(item.notes!)
                        .font(.subheadline)
                }
            }
        }
    }
}

struct TodoItemRow_Previews: PreviewProvider {
    static var previews: some View {
        TodoItemRow(item: defaultTodoItems[0])
            .previewLayout(.sizeThatFits)
    }
}
